import React, {memo, FC} from 'react';

import {IWithClassName} from 'types/IWithClassName';

interface IArrowRightProps extends IWithClassName {}

const ArrowRight: FC<IArrowRightProps> = props => {
    const {className} = props;

    return (
        <svg
            className={className}
            width="16"
            height="12"
            viewBox="0 0 16 12"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M9.29 1.90806C9.10236 1.72042 8.99694 1.46592 8.99694 1.20056C8.99694 0.935193 9.10236 0.680697 9.29 0.493057C9.47764 0.305416 9.73214 0.200001 9.9975 0.200001C10.2629 0.200001 10.5174 0.305416 10.705 0.493057L15.503 5.29206C15.6905 5.47958 15.7958 5.73389 15.7958 5.99906C15.7958 6.26422 15.6905 6.51853 15.503 6.70606L10.704 11.5041C10.5164 11.6916 10.2619 11.7969 9.99665 11.7968C9.73138 11.7967 9.47701 11.6912 9.2895 11.5036C9.10199 11.3159 8.9967 11.0615 8.9968 10.7962C8.99689 10.5309 9.10236 10.2766 9.29 10.0891L10.703 8.67706C11.2349 8.14579 11.8249 7.67616 12.462 7.27706L13.209 6.80706L13.162 6.76106L12.203 6.89806C11.7346 6.9648 11.2621 6.99821 10.789 6.99806H1C0.734784 6.99806 0.48043 6.8927 0.292893 6.70516C0.105357 6.51763 0 6.26327 0 5.99806C0 5.73284 0.105357 5.47849 0.292893 5.29095C0.48043 5.10341 0.734784 4.99806 1 4.99806H10.79C11.2631 4.99823 11.7357 5.03198 12.204 5.09906L13.164 5.23606L13.21 5.18906L12.46 4.71906C11.824 4.32015 11.2349 3.85086 10.704 3.32006L9.29 1.90806Z"
                fill="currentColor"
            />
        </svg>
    );
};

export default memo(ArrowRight);
