import React, {memo, FC} from 'react';

import {IWithClassName} from 'types/IWithClassName';

import * as i18n from 'i18n/bus-Ticket';

import Text from 'components/Text/Text';

import cx from './Description.scss';

interface IDescriptionProps extends IWithClassName {
    text: string;
}

const Description: FC<IDescriptionProps> = props => {
    const {className, text} = props;

    return (
        <div className={className}>
            <Text className={cx('title')} color="secondary" size="xs">
                {i18n.routeTitle()}
            </Text>

            <div className={cx('text')}>{text}</div>
        </div>
    );
};

export default memo(Description);
