import React, {memo, FC} from 'react';
import moment from 'moment';

import {IWithClassName} from 'types/IWithClassName';

import Text from 'components/Text/Text';

import cx from './Point.scss';

interface IPointProps extends IWithClassName {
    title: string;
    time?: string;
    pointTitle: string;
    pointDescription: string;
}

const Point: FC<IPointProps> = props => {
    const {className, title, time, pointTitle, pointDescription} = props;

    const timeMoment = time ? moment.utc(time) : null;

    return (
        <div className={className}>
            <Text className={cx('title')} size="xs" color="secondary">
                {title}
            </Text>

            <div
                className={cx('timesAndPoints', {
                    timesAndPoints_withoutTime: !timeMoment,
                })}
            >
                {timeMoment && (
                    <Text size="xl">{timeMoment.format('HH:mm')}</Text>
                )}
                <Text className={cx('point')} size="xl">
                    {pointTitle}
                </Text>

                {timeMoment && (
                    <Text size="s">{timeMoment.format('DD MMM')}</Text>
                )}
                <Text className={cx('point')} size="s" color="secondary">
                    {pointDescription}
                </Text>
            </div>
        </div>
    );
};

export default memo(Point);
