import React, {PureComponent} from 'react';
import ReactTruncate from 'react-truncate';

import {IWithClassName} from 'types/IWithClassName';
import IAmenity from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/IAmenity';

import * as i18n from 'i18n/hotels-BookVoucherPDF';

import cx from './BookHotelAmenities.scss';

interface IBookHotelAmenitiesProps extends IWithClassName {
    amenities: Record<string, IAmenity>;
}

interface IBookHotelAmenitiesState {
    canRenderAllLines: boolean;
}

class BookHotelAmenities extends PureComponent<
    IBookHotelAmenitiesProps,
    IBookHotelAmenitiesState
> {
    state: IBookHotelAmenitiesState = {
        canRenderAllLines: true,
    };

    getAmenitiesList(): IAmenity[] {
        const {amenities} = this.props;

        return Object.values(amenities);
    }

    handleTruncateMoreButtonClick = (): void => {
        this.setState({canRenderAllLines: true});
    };

    renderTruncateEllipsis = (): React.ReactNode => {
        return (
            <span className={cx('truncateEllipsis')}>
                <span className={cx('truncateEllipsisDots')}>...</span>
                <button
                    className={cx('truncateEllipsisMore')}
                    onClick={this.handleTruncateMoreButtonClick}
                >
                    {i18n.allAmenitiesLink()}
                </button>
            </span>
        );
    };

    renderAmenitiesTitle(): React.ReactNode {
        return <h5 className={cx('title')}>{i18n.amenitiesTitle()}</h5>;
    }

    renderAmenities(): React.ReactNode {
        const {canRenderAllLines} = this.state;
        const amenitiesList = this.getAmenitiesList();
        const middleDotNode = <span>&nbsp;&nbsp;&nbsp;&#183;&ensp;</span>;

        return (
            <ReactTruncate
                lines={canRenderAllLines ? false : 1}
                ellipsis={this.renderTruncateEllipsis()}
            >
                {amenitiesList.map(({id, name}, index) => (
                    <span key={id}>
                        {index === 0 ? null : middleDotNode}
                        {name}
                    </span>
                ))}
            </ReactTruncate>
        );
    }

    render(): React.ReactNode {
        const {className} = this.props;
        const amenitiesList = this.getAmenitiesList();
        const canRenderHotelAmenities = amenitiesList.length > 0;

        return (
            canRenderHotelAmenities && (
                <section className={cx('bookHotelAmenities', className)}>
                    {this.renderAmenitiesTitle()}
                    {this.renderAmenities()}
                </section>
            )
        );
    }
}

export default BookHotelAmenities;
