import React from 'react';

import {IWithClassName} from 'types/IWithClassName';

import * as i18n from 'i18n/hotels-BookVoucherPDF';

import cx from './BookMealInfo.scss';

interface IBookMealInfoProps extends IWithClassName {
    meal: string;
}

const BookMealInfo: React.FC<IBookMealInfoProps> = ({className, meal}) => (
    <section className={cx('mealInfo', className)}>
        <h5 className={cx('title')}>{i18n.mealTitle()}</h5>
        <div className={cx('mealName')}>{meal}</div>
    </section>
);

export default BookMealInfo;
