import React from 'react';

import {IWithClassName} from 'types/IWithClassName';
import IBedGroupInfo from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/IBedGroupInfo';

import * as i18n from 'i18n/hotels-BookVoucherPDF';

import cx from './BookSelectBedsGroups.scss';

interface IBookSelectBedsGroupsProps extends IWithClassName {
    bedGroups: IBedGroupInfo[];
}

const BookSelectBedsGroups: React.FC<IBookSelectBedsGroupsProps> = props => {
    const {className, bedGroups} = props;

    if (!bedGroups?.length) {
        return null;
    }

    const [firstBedsGroup] = bedGroups;
    const {description} = firstBedsGroup;

    return (
        <div className={cx('bookSelectBedsGroups', className)}>
            <div className={cx('title')}>{i18n.bedsGroups()}</div>
            <div className={cx('bedsGroup')}>{description}</div>
        </div>
    );
};

export default BookSelectBedsGroups;
