import React, {PureComponent} from 'react';

import {IWithClassName} from 'types/IWithClassName';
import IFees from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/IPartnerHotelInfo/IFees';

import * as i18n from 'i18n/hotels-BookSettlementInfo';

import cx from './BookSettlementInfo.scss';

interface IBookSettlementInfoProps extends IWithClassName {
    instructions: string;
    specialInstructions: string;
    fees: IFees;
    knowBeforeYouGo: string;
}

interface IBookSettlementInfoState {
    canRenderAllInfo: boolean;
}

class BookSettlementInfo extends PureComponent<
    IBookSettlementInfoProps,
    IBookSettlementInfoState
> {
    state: IBookSettlementInfoState = {
        canRenderAllInfo: true,
    };

    toggleSettlementView = (): void => {
        this.setState(({canRenderAllInfo}) => ({
            canRenderAllInfo: !canRenderAllInfo,
        }));
    };

    getSettlementInfo(): string[] {
        const {
            fees,
            instructions,
            specialInstructions,
            knowBeforeYouGo,
        } = this.props;

        return [
            fees.mandatory,
            specialInstructions,
            instructions,
            fees.optional,
            knowBeforeYouGo,
        ].filter(Boolean);
    }

    renderSettlementItems(items: string[]): React.ReactNode {
        return (
            <>
                {items.map((settlementText, index) => (
                    <div
                        key={index}
                        dangerouslySetInnerHTML={{__html: settlementText}}
                    />
                ))}
            </>
        );
    }

    renderSettlementInfo(): React.ReactNode {
        const settlementInfoItems = this.getSettlementInfo();

        return (
            <div className={cx('settlementInfoContent')}>
                {this.renderSettlementItems(settlementInfoItems)}
            </div>
        );
    }

    renderTitle(): React.ReactNode {
        return (
            <h5
                onClick={this.toggleSettlementView}
                className={cx('settlementInfoTitle')}
            >
                {i18n.title()}
            </h5>
        );
    }

    render(): React.ReactNode {
        const {className} = this.props;
        const settlementInfoItems = this.getSettlementInfo();

        return (
            settlementInfoItems.length > 0 && (
                <section className={cx('settlementInfo', className)}>
                    {this.renderTitle()}
                    {this.renderSettlementInfo()}
                </section>
            )
        );
    }
}

export default BookSettlementInfo;
