import React from 'react';

import {IWithClassName} from 'types/IWithClassName';
import IBedGroupInfo from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/IBedGroupInfo';
import IFees from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/IPartnerHotelInfo/IFees';
import {IRoomContentInfo} from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/IRoomContentInfo';
import ILocalizedPansionInfo from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/ILocalizedPansionInfo/ILocalizedPansionInfo';

import BookSettlementInfo from 'projects/hotels/components/BookSettlementInfo/BookSettlementInfo';
import BookHotelAmenities from 'projects/hotels/components/BookHotelAmenities/BookHotelAmenities';
import BookSelectBedsGroups from 'projects/hotels/components/BookSelectBedsGroups/BookSelectBedsGroups';
import BookMealInfo from 'projects/hotels/components/BookMealInfo/BookMealInfo';

import cx from './OrderRoomInfo.scss';

interface IOrderRoomInfo extends IWithClassName {
    roomInfo: IRoomContentInfo;
    pansionInfo: ILocalizedPansionInfo | undefined;
    bedGroups: IBedGroupInfo[];
    instructions: string;
    specialInstructions: string;
    fees: IFees;
    knowBeforeYouGo: string;
}

const OrderRoomInfo: React.FC<IOrderRoomInfo> = props => {
    const {
        className,
        roomInfo,
        pansionInfo,
        bedGroups,
        instructions,
        specialInstructions,
        fees,
        knowBeforeYouGo,
    } = props;

    return (
        <section className={cx('orderRoomInfo', className)}>
            <h3 className={cx('name')}>{roomInfo.name}</h3>
            {pansionInfo && (
                <BookMealInfo
                    className={cx('mealInfo')}
                    meal={pansionInfo.name}
                />
            )}
            <BookSelectBedsGroups
                className={cx('bedsGroups')}
                bedGroups={bedGroups}
            />
            <BookHotelAmenities
                className={cx('amenities')}
                amenities={roomInfo.amenities}
            />
            <BookSettlementInfo
                instructions={instructions}
                specialInstructions={specialInstructions}
                fees={fees}
                knowBeforeYouGo={knowBeforeYouGo}
            />
        </section>
    );
};

export default OrderRoomInfo;
