import React from 'react';
import insertJSXIntoKey from '@yandex-data-ui/i18n-ts/client/insertJSXIntoKey';
import {useSelector} from 'react-redux';

import businessTripDocSelector from 'selectors/hotels/businessTripDocSelector';

import getPriceWithCurrency from 'projects/hotels/pages/BusinessTripDoc/utilities/getPriceWithCurrency';
import getReceipts from 'projects/hotels/pages/BusinessTripDoc/utilities/getReceipts';

import * as i18n from 'i18n/hotels-BusinessTripDoc';

import YandexTravelLogo from 'components/YandexTravelLogo/YandexTravelLogo';
import YandexDocHeader from 'projects/hotels/pages/BusinessTripDoc/components/YandexDocHeader/YandexDocHeader';
import {Link} from '@yandex-lego/components/Link';
import RouteWithStatusCode from 'components/RouteWithStatusCode/RouteWithStatusCode';
import YandexSeal from './components/YandexSeal/YandexSeal';

import {serverFetchDataDispatcher} from 'contexts/ServerFetchDataContext';

import fetchBusinessTripDoc from 'server/redux/hotels/fetchBusinessTripDoc';

import cx from './BusinessTripDoc.scss';

interface IBusinessTripDocProps {}

const BusinessTripDoc: React.FC<IBusinessTripDocProps> = () => {
    const {order} = useSelector(businessTripDocSelector);

    if (!order) {
        return <RouteWithStatusCode statusCode={502} />;
    }

    const {
        guestNames,
        userEmail,
        displayApplicationDate,
        hotelName,
        hotelAddress,
        displayCheckinDate,
        displayCheckoutDate,
        totalPrice,
        receiptNumbers,
    } = order;

    const guests = guestNames.join(', ');

    return (
        <div className={cx('root')}>
            <div className={cx('content')}>
                <YandexTravelLogo className={cx('logo')} />
                <YandexDocHeader className={cx('header')} />
                <div className={cx('body')}>
                    {insertJSXIntoKey(i18n.body)({
                        user: guests,
                        applicationDate: displayApplicationDate,
                        userBold: <strong>{guests}</strong>,
                        travelLink: (
                            <Link href={i18n.travelUrl()}>
                                {i18n.travelUrl()}
                            </Link>
                        ),
                        hotelName,
                        hotelAddress,
                        checkinDate: displayCheckinDate,
                        checkoutDate: displayCheckoutDate,
                        totalPrice: getPriceWithCurrency(totalPrice),
                        receipts: getReceipts(receiptNumbers),
                        userEmail: (
                            <Link href={`mailto:${userEmail}`}>
                                {userEmail}
                            </Link>
                        ),
                    })}
                </div>
                <div className={cx('sign')}>{i18n.footer()}</div>
                <div className={cx('seal')}>
                    <YandexSeal />
                </div>
            </div>
        </div>
    );
};

export default serverFetchDataDispatcher([fetchBusinessTripDoc])(
    BusinessTripDoc,
);
