import React from 'react';

import {IWithClassName} from 'types/IWithClassName';

import * as i18n from 'i18n/common-yandex';

import cx from './YandexDocHeader.scss';

interface IYandexDocHeaderProps extends IWithClassName {}

const YandexDocHeader: React.FC<IYandexDocHeaderProps> = props => {
    const {className} = props;

    return (
        <div className={cx(className, 'root')}>
            <div>{i18n.name()}</div>
            <div>{i18n.addressStreet()}</div>
            <div>{i18n.addressCity()}</div>
            <div>{i18n.phone()}</div>
            <div>{i18n.fax()}</div>
            <div>{i18n.website()}</div>
            <div>{i18n.email()}</div>
        </div>
    );
};

export default YandexDocHeader;
