import IPrice from 'types/common/IPrice';
import CurrencyType from 'types/common/CurrencyType';

import * as i18n from 'i18n/common-units';

export default function getPriceWithCurrency(price: IPrice): string {
    if (price.currency !== CurrencyType.RUB) {
        throw new Error('Implement only "RUB"');
    }

    return i18n.rubles({
        count: price.value,
    });
}
