import moment from 'moment';

import IHotelSearchRequestInfo from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/IHotelSearchRequestInfo';
import ICheckin from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/IPartnerHotelInfo/ICheckin';
import ICheckout from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/IHotelOfferInfo/IPartnerHotelInfo/ICheckout';

import * as i18n from 'i18n/hotels-BookVoucherPDF';

const getTotalNights = (startDate: string, endDate: string): number =>
    moment(endDate).diff(moment(startDate), 'days');

const prepareSearchDate = (date: string): string =>
    moment(date).format('D MMMM, ddd');

interface ICheckParams {
    checkin: ICheckin;
    checkout: ICheckout;
    requestInfo: IHotelSearchRequestInfo;
}

export interface ICheckDates {
    checkinData: {
        title: string;
        value: string;
    };
    checkoutData: {
        title: string;
        value: string;
    };
    totalNights: number;
}

export default function getHotelCheckDates(
    checkParams: ICheckParams,
): ICheckDates {
    const {
        checkin: {beginTime: checkinBeginTime, endTime: checkinEndTime},
        checkout: {time: checkoutEndTime},
        requestInfo: {checkinDate, checkoutDate},
    } = checkParams;

    const totalNights = getTotalNights(checkinDate, checkoutDate);
    const preparedCheckinBeginTime =
        Boolean(checkinBeginTime) && checkinBeginTime;
    const preparedCheckinEndTime = Boolean(checkinEndTime) && checkinEndTime;
    const preparedCheckoutEndTime = Boolean(checkoutEndTime) && checkoutEndTime;

    const checkinText = i18n.checkin({
        beginTime: preparedCheckinBeginTime,
        endTime: preparedCheckinEndTime,
    });
    const checkoutText = i18n.checkout({
        endTime: preparedCheckoutEndTime,
    });

    const preparedStartDate = `${prepareSearchDate(
        checkinDate,
    )} ${checkinText}`;
    const preparedEndDate = `${prepareSearchDate(
        checkoutDate,
    )} ${checkoutText}`;

    return {
        checkinData: {
            title: i18n.checkinDotTitle(),
            value: preparedStartDate,
        },
        checkoutData: {
            title: i18n.checkoutDotTitle(),
            value: preparedEndDate,
        },
        totalNights,
    };
}
