import React, {useEffect, useState} from 'react';

import {
    getBusesTicketUrl,
    getHotelsBookVoucherUrl,
    getHotelsBusinessTripDocUrl,
} from 'constants/urls';

import DocumentGenerator from 'projects/index/pages/components/DocumentGenerator/DocumentGenerator';

import cx from './IndexPage.scss';

interface IIndexPageProps {}

const IndexPage: React.FC<IIndexPageProps> = () => {
    const [origin, setOrigin] = useState('');

    useEffect(() => {
        setOrigin(window.location.host);
    }, []);

    return (
        <div className={cx('root')}>
            <h1>Сервис генерации pdf документов (демо-страница)</h1>
            <DocumentGenerator
                className={cx('block')}
                title="Отельный ваучер"
                apiGeneratePath="/pdf/generateHotelVoucher"
                origin={origin}
                exampleOrderId="d628ca5f-515f-4814-8503-eec442b3eb09"
                exampleFileName="document_YA-0141-9551-1253.pdf"
                getViewUrl={getHotelsBookVoucherUrl}
            />
            <DocumentGenerator
                className={cx('block')}
                title="Билет на автобус"
                apiGeneratePath="/pdf/generateBusesTickets"
                origin={origin}
                exampleOrderId="1d50f6cf-5725-4f9b-9ff6-6d67ec760bed"
                exampleFileName="buses/ticket_YA-8951-3920-1992.pdf"
                passengerIndex={0}
                getViewUrl={getBusesTicketUrl}
            />
            <DocumentGenerator
                className={cx('block')}
                title="Документ для бухгалтерии о проживании в отеле после командировки"
                apiGeneratePath="/pdf/generateHotelBusinessTripDoc"
                origin={origin}
                exampleOrderId="d628ca5f-515f-4814-8503-eec442b3eb09"
                exampleFileName="hotel-business-trip-docs/YA-0141-9551-1253.pdf"
                getViewUrl={getHotelsBusinessTripDocUrl}
            />
        </div>
    );
};

export default IndexPage;
