/* global __REDUX_DEV_TOOLS__ __CLIENT__ */
import {configureStore} from '@reduxjs/toolkit';
import {Store} from 'redux';
import thunk from 'redux-thunk';

import rootReducer, {IStoreInterface} from 'reducers/rootReducer';

let preLoadedReduxState = {};

if (__CLIENT__) {
    preLoadedReduxState = window.__PRELOADED_REDUX_STATE__;

    delete window.__PRELOADED_REDUX_STATE__;
}

export default (): Store<IStoreInterface> => {
    return configureStore({
        reducer: rootReducer,
        middleware: getDefaultMiddleware =>
            getDefaultMiddleware().concat(thunk),
        devTools: __REDUX_DEV_TOOLS__,
        preloadedState: preLoadedReduxState,
    });
};
