import {createSlice, PayloadAction} from '@reduxjs/toolkit';

import IGetOrderForBusinessTripDocResponse from 'server/api/TravelApi/types/getOrderForBusinessTripDoc/IGetOrderForBusinessTripDocResponse';

interface IBusinessTripDocState {
    order: IGetOrderForBusinessTripDocResponse | null;
}

const initialState: IBusinessTripDocState = {
    order: null,
};

const businessTripDoc = createSlice({
    name: 'businessTripDoc',
    initialState,
    reducers: {
        setOrder(
            state,
            action: PayloadAction<IGetOrderForBusinessTripDocResponse>,
        ): void {
            state.order = action.payload;
        },
    },
});

export default businessTripDoc;
