import {createSlice, PayloadAction} from '@reduxjs/toolkit';

import IGetHotelOrderResponse from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/IGetHotelOrderResponse';

interface IHotelOrderState {
    order: IGetHotelOrderResponse | null;
}

const initialState: IHotelOrderState = {
    order: null,
};

const hotelOrder = createSlice({
    name: 'hotelOrder',
    initialState,
    reducers: {
        setOrder(state, action: PayloadAction<IGetHotelOrderResponse>): void {
            state.order = action.payload;
        },
    },
});

export default hotelOrder;
