import {createSlice, PayloadAction} from '@reduxjs/toolkit';

import {IOrderInfo} from '../../../../server/api/TravelApi/types/getAdminOrder/IGetAdminOrderResponse';

interface IOrderState {
    order: IOrderInfo | null;
}

const initialState: IOrderState = {
    order: null,
};

const order = createSlice({
    name: 'order',
    initialState,
    reducers: {
        setOrder(state, action: PayloadAction<IOrderInfo>): void {
            state.order = action.payload;
        },
    },
});

export default order;
