import {combineReducers} from 'redux';

import hotelOrder from './hotels/hotelOrder';
import businessTripDoc from './hotels/businessTripDoc';
import order from './order/order';

export interface IStoreInterface {
    [order.name]: ReturnType<typeof order.reducer>;
    [hotelOrder.name]: ReturnType<typeof hotelOrder.reducer>;
    [businessTripDoc.name]: ReturnType<typeof businessTripDoc.reducer>;
}

export default combineReducers<IStoreInterface>({
    [order.name]: order.reducer,
    [hotelOrder.name]: hotelOrder.reducer,
    [businessTripDoc.name]: businessTripDoc.reducer,
});
