import {TTimeOfDay} from 'utilities/dateUtils/types';

export const MORNING: TTimeOfDay = 'morning';
export const DAY: TTimeOfDay = 'day';
export const EVENING: TTimeOfDay = 'evening';
export const NIGHT: TTimeOfDay = 'night';

export const TIMES_OF_DAY: TTimeOfDay[] = [MORNING, DAY, EVENING, NIGHT];

export const TIMES_RANGES: Record<TTimeOfDay, {start: number; end: number}> = {
    [NIGHT]: {
        start: 0,
        end: 6,
    },
    [MORNING]: {
        start: 6,
        end: 12,
    },
    [DAY]: {
        start: 12,
        end: 18,
    },
    [EVENING]: {
        start: 18,
        end: 0,
    },
};
