import fse from 'fs-extra';
import chalk from 'chalk';
import {Builder} from '@yandex-data-ui/i18n-ts';

import {TRAVEL_TANKER_BRANCH, TRAVEL_TANKER_PROJECT} from './constants';

import {i18nPath} from '../../webpack/utilities/getPathParams';

import {readFromFiles} from './readFromFiles';

(async function readFromFilesAndBuild(): Promise<void> {
    try {
        await fse.ensureDir(i18nPath);

        const translations = await readFromFiles();

        const builder = new Builder({
            outFolder: i18nPath,
            tankerLinkOptions: {
                base: 'https://tanker.yandex-team.ru',
                isNewTanker: true,
                branch: TRAVEL_TANKER_BRANCH,
                project: TRAVEL_TANKER_PROJECT,
            },
        });

        await builder.build(translations);

        console.log(chalk.green('Tanker built success'));
    } catch (e) {
        const message = e instanceof Error ? e.message : String(e);

        console.error(
            chalk.red(
                message,
                TRAVEL_TANKER_PROJECT,
                'Tanker built with errors',
            ),
        );

        throw e;
    }
})();
