/* eslint-disable import-helpers/order-imports */

const path = require('path');
const {mergeWithRules, CustomizeRule} = require('webpack-merge');
const nodeExternals = require('webpack-node-externals');

const createCommonWebpackConfig = require('./common.webpack.config');

const commonWebpackConfig = createCommonWebpackConfig({isServer: true});
const {
    rootPath,
    serverBuildPath,
    excludeNodeModulesRegExpPath,
} = require('./utilities/getPathParams');

const smartStrategyMergeParams = {
    module: {
        rules: {
            test: CustomizeRule.Match,
            include: CustomizeRule.Match,
            exclude: CustomizeRule.Match,
            use: CustomizeRule.Prepend,
        },
        plugins: CustomizeRule.Prepend,
    },
};

const serverEntry = [path.join(rootPath, 'server', 'renderServer.tsx')];
const pdfControllerEntry = [path.join(rootPath, 'server', 'pdfController.ts')];

const prependStylesLoaders = ['classnames-loader', 'node-style-loader'];

const serverWebpackConfig = {
    name: 'server',
    target: 'node',
    externals: [nodeExternals({allowlist: [/@yandex-lego/]})],
    entry: {
        renderServer: serverEntry,
        pdfController: pdfControllerEntry,
    },
    output: {
        path: serverBuildPath,
        libraryTarget: 'commonjs2',
    },
    module: {
        rules: [
            {
                test: /\.([tj])sx?$/,
                exclude: excludeNodeModulesRegExpPath,
                use: [
                    {
                        loader: 'babel-loader',
                        options: {
                            presets: [
                                [
                                    '@babel/preset-env',
                                    {
                                        corejs: 3,
                                        useBuiltIns: 'entry',
                                        targets: {
                                            node: 'current',
                                        },
                                    },
                                ],
                                '@babel/preset-react',
                                [
                                    '@babel/preset-typescript',
                                    {allowNamespaces: true},
                                ],
                            ],
                        },
                    },
                ],
            },
            {
                test: /\.scss$/,
                exclude: excludeNodeModulesRegExpPath,
                use: prependStylesLoaders,
            },
            {
                test: /\.css$/,
                exclude: excludeNodeModulesRegExpPath,
                use: prependStylesLoaders,
            },
        ],
    },
};

module.exports = mergeWithRules(smartStrategyMergeParams)(
    commonWebpackConfig,
    serverWebpackConfig,
);
