const path = require('path');
const fse = require('fs-extra');

const {isDevelopment} = require('../variables');

// eslint-disable-next-line security/detect-non-literal-fs-filename
const rootPath = fse.realpathSync(process.cwd());
const nodeModulesPath = path.join(rootPath, 'node_modules');
const srcPath = path.join(rootPath, 'src');
const stylesPath = path.join(srcPath, 'styles');
const prerequisitesPath = path.join(srcPath, 'prerequisites');
const i18nPath = path.join(prerequisitesPath, 'i18n');
const buildPath = path.join(rootPath, 'build');
const publicSourcePath = path.join(rootPath, 'public');
const publicBuildPath = path.join(buildPath, 'public');
const clientBuildPath = path.join(buildPath, 'client');
const serverBuildPath = path.join(buildPath, 'server');
const clientPublicPath = isDevelopment ? '/webpackStatic/' : '/static/assets/';

const excludeNodeModulesRegExpPath = /node_modules\/(?!(@yandex-lego)\/).*/;

module.exports = {
    srcPath,
    stylesPath,
    rootPath,
    prerequisitesPath,
    i18nPath,
    buildPath,
    nodeModulesPath,
    publicBuildPath,
    clientBuildPath,
    serverBuildPath,
    clientPublicPath,
    publicSourcePath,
    excludeNodeModulesRegExpPath,
};
