import React from 'react';

import DeviceTypeContext from '../../src/contexts/DeviceTypeContext';

const desktop = {
    isMobile: false,
    isTouch: false,
    isDesktop: true,
    isIe: false,
    os: {
        version: '',
        name: '',
    },
};

const mobile = {
    isMobile: true,
    isTouch: true,
    isDesktop: false,
    isIe: false,
    os: {
        version: '',
        name: '',
    },
};

export const deviceTypeToolbarConf = {
    name: 'DeviceType',
    defaultValue: 'desktop',
    toolbar: {
        // https://github.com/storybookjs/storybook/blob/c5cafac7d42057cc7b04eabde7722e16f6f516b7/docs/workflows/faq.md#what-icons-are-available-for-my-toolbar-or-my-addon
        icon: 'tablet',
        items: [
            {title: 'Desktop', value: 'desktop'},
            {title: 'Mobile', value: 'mobile'},
        ],
    },
};

export const withDeviceType = (Story, context) => {
    const deviceType = context.globals.device === 'desktop' ? desktop : mobile;

    return (
        <DeviceTypeContext.Provider value={deviceType}>
            <Story {...context} />
        </DeviceTypeContext.Provider>
    );
};
