import {setDateLocale} from 'utilities/dateUtils';
import locales from 'utilities/dateUtils/locales';

import {
    withDeviceType,
    deviceTypeToolbarConf,
} from './decorators/withDeviceType';
import {withReduxStore} from './decorators/withReduxStore';
import {withInfo} from './decorators/withInfo';

import 'src/containers/App/App.scss';
import './styles/fonts.css';
import './styles/colors.scss';
import 'src/prerequisites/theme/default.css';

export const parameters = {
    options: {
        storySort: {order: ['Common', 'Example', 'Avia', 'Hotels', 'Trains']},
    },
};

export const globalTypes = {
    device: deviceTypeToolbarConf,
};

setDateLocale(locales.RU);

export const decorators = [withDeviceType, withReduxStore, withInfo];
