/* eslint-disable @typescript-eslint/naming-convention */
import {Span} from 'opentracing';
import {TracingOptions} from 'jaeger-client';
import {Overwrite} from 'utility-types';

import {TLD} from 'constants/tld';
import {EProjectName} from 'constants/common';
import {TPlatform} from 'constants/platforms/TPlatforms';

import {IAdFoxParams} from 'types/AdFox';
import {EApiEntry} from 'types/EApiEntry';
import {
    TExperiments,
    THandler,
    IUserSplit,
} from 'server/providers/experiments/types';
import {IUATraits} from 'types/common/IUATraits';
import {CoreUtils} from '@yandex-data-ui/core/build/types';
import {PassportConfig} from '@yandex-data-ui/core/lib/types';
import {TAviaLogName} from 'server/loggers/avia/types/TAviaLogName';
import {IAviaLogConfig} from 'server/loggers/avia/types/IAviaLogConfig';
import {TBlackboxUserInfo} from 'types/common/userInfo/TBlackboxUserInfo';
import {IAviaVisitSourceIds} from 'server/loggers/avia/types/IAviaVisitSourceIds';

import {INativeAppState} from 'reducers/avia/platform/reducer';

import config from 'server/configs/common';
import {INationalSettings} from 'server/getContainerConfig';
import {ApiRequestChannel} from 'server/sockets/apiRequestsChannel';

interface ITravelResponse {
    aviaCookie: (
        cookieName: string,
        cookieValue: any,
        cookieParams?: any,
    ) => void;
    aviaClearCookie: (cookieName: string) => void;
    hasCookie: (cookieName: string) => boolean;
    getCookie: (cookieName: string) => any;
}

declare module 'express-serve-static-core' {
    // eslint-disable-next-line @typescript-eslint/naming-convention
    interface Response extends ITravelResponse {}
}

declare module '@yandex-data-ui/core/lib/types' {
    // eslint-disable-next-line
    import {AwilixContainer} from 'awilix';

    // eslint-disable-next-line @typescript-eslint/naming-convention
    export interface Request {
        cookies: ICookies; // Потому что в типах express стоит any.
        userInfo: TBlackboxUserInfo;
        isBot: boolean;
        unreadMailCount?: number;
        container: AwilixContainer;
        experiments: TExperiments;
        userSplit: IUserSplit;
        session: {
            yaTravelSessionUid?: string;
        };
        tld: TLD;
        uatraits: IUATraits;
        nationalVersion: string;
        startTime: number;
        geoId?: number;
        rootSpan?: Span;
        platform?: TPlatform;
        isFakeApp?: boolean;
        nativeAppVersion?: string;
        nativeAppState?: INativeAppState;
        apiRequestsChannel: ApiRequestChannel;
        utils: Overwrite<
            CoreUtils,
            {
                config: Overwrite<
                    CoreConfig,
                    {
                        passport: PassportConfig & {
                            avatarPath: string;
                            passportPath: string;
                        };
                    }
                >;
            }
        >;

        /** Метки авиа аттрибуции */
        aviaVisitSourceIds: IAviaVisitSourceIds;
    }

    // eslint-disable-next-line @typescript-eslint/naming-convention
    interface Response extends ITravelResponse {}

    // eslint-disable-next-line @typescript-eslint/naming-convention
    export interface AppRequestHandler {
        (req: Request, res: Response): void | Promise<void>;
    }

    export interface ICookies {
        [key: string]: string;
    }

    // eslint-disable-next-line @typescript-eslint/naming-convention
    export interface CoreConfig {
        servicesAPI: Record<EApiEntry, string>;
        adFox: IAdFoxParams;
        nationalSettings: Record<string, INationalSettings>;
        environmentConfig: {
            secureIFramePath: string;
            uxfeedbackIframeSrc: string;
        };
        uaasExperiments: TUaasExperiments;
        telemetryClickHouseEnvTable: string;
        fileLogging: IFileLoggingConfig | null;
        orders: {
            canUseMockPayment: boolean;
            canUseTestContext: boolean;
        };
        uaas: {
            uri: string;
            handler: THandler;
            env: 'testing' | 'production';
        };
        csrf: {
            secret: string;
            lifetime: number;
        };
        travelTracing: TracingOptions & {
            meta?: {
                forceDebugTag: boolean;
            };
        };
    }

    export type TUaasExperiments = typeof config.uaasExperiments;

    interface IFileLoggingConfig {
        [EProjectName.AVIA]: Record<TAviaLogName, IAviaLogConfig>;
    }
}

declare global {
    // eslint-disable-next-line @typescript-eslint/naming-convention
    interface Window {
        webkit: any;
        AndroidNativeInterface: any;
    }
}
