/* eslint-disable @typescript-eslint/naming-convention */

type ImportedReact = import('react');

interface IAmpImage {
    layout: 'responsive' | 'intrinsic' | 'fixed';
}

interface IAmpSideBarAttrs {
    side: 'left' | 'right';
    layout: 'nodisplay';
    class: string;
}

interface IAmpCarousel {
    /** @default 'carousel' */
    type?: 'carousel' | 'slides';
    height: number;
    class?: string;
}

interface IAmpLightbox {
    layout: 'nodisplay';
    /** @default fade-in */
    'animate-in'?: 'fade-in' | 'fly-in-bottom' | 'fly-in-top';
}

interface IAmpTextTruncate {
    layout: 'fixed-height';
    height: `${number}em`;
}

declare namespace JSX {
    interface IntrinsicElements {
        'amp-img': ImportedReact.DetailedHTMLProps<
            ImportedReact.ImgHTMLAttributes<HTMLImageElement>,
            HTMLImageElement
        > &
            IAmpImage;
        'amp-sidebar': ImportedReact.DetailedHTMLProps<
            ImportedReact.HTMLAttributes<HTMLElement>,
            HTMLElement
        > &
            IAmpSideBarAttrs;
        'amp-carousel': ImportedReact.DetailedHTMLProps<
            ImportedReact.HTMLAttributes<HTMLElement>,
            HTMLElement
        > &
            IAmpCarousel;
        'amp-lightbox': ImportedReact.DetailedHTMLProps<
            ImportedReact.HTMLAttributes<HTMLElement>,
            HTMLElement
        > &
            IAmpLightbox;
        'amp-truncate-text': ImportedReact.DetailedHTMLProps<
            ImportedReact.HTMLAttributes<HTMLElement>,
            HTMLElement
        > &
            IAmpTextTruncate;
    }
}
