/**
 * У calendar-base нет тайпингов
 * @see node_modules/calendar-base/lib/calendar-base.js
 **/
declare module 'calendar-base' {
    type TCalendarOptions = {
        startDate: Date;
        endDate: Date;
        siblingMonths: boolean;
        weekNumbers: boolean;
        weekStart: number;
    };

    type TMonthNumber = 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11;
    type TCalendarDateObject = {day: number; month: TMonthNumber; year: number};

    export class Calendar {
        getCalendar: (
            year: number,
            month: TMonthNumber,
        ) => TCalendarDateObject[];

        constructor(options?: Partial<TCalendarOptions>);
    }
}
