interface IMetrika {
    reachGoal(goal: string, ...params: IMetrikaParams[]): void;
    params(...params: IMetrikaParams[]): void;
    userParams(...params: IMetrikaParams[]): void;
    hit(url: string, options?: IMetrikaHitOptions): void;
    getClientID(callback: (clientId: string) => unknown);
    setUserID(userID: string): void;
}

interface IMetrikaParams {
    [key: string]: any;
}

type TMetrikaQueueItem =
    | {props: IMetrikaParams[]}
    | {target: string; props: IMetrikaParams[]}
    | {user: true; props: IMetrikaParams[]};

interface IMetrikaHitOptions {
    callback?: () => void;
    ctx?: {[k: string]: any};
    params?: IMetrikaParams;
    referer?: string;
    title?: string;
}
