declare module 'react-yandex-maps' {
    interface AnyObject {
        [key: string]: any;
    }

    export interface IYMapsInstance extends AnyObject {}

    export interface IYMapsApi extends AnyObject {}

    interface CommonProps {
        instanceRef?: (ref: IYMapsInstance) => void;
        onLoad?: (ymaps: IYMapsApi) => void;
        onError?: (error: Error) => void;
        onBoundsChange?: (boundsChangeParams: IYaBoundsChangeEvent) => void;
        onActionBegin?: () => void;
        onActionEnd?: () => void;
        onActionTick?: (tickEvent: ITickEvent) => void;
        onClick?: () => void;
        modules?: string[];
    }

    export interface YMapsProps extends AnyObject {
        version?: string;
        enterprise?: boolean;
        query?: {
            lang?: 'tr_TR' | 'en_US' | 'en_RU' | 'ru_RU' | 'ru_UA' | 'uk_UA';
            apikey?: string;
            coordorder?: 'latlong' | 'longlat';
            load?: string;
            mode?: 'release' | 'debug';
            csp?: boolean;
            ns?: string;
        };
        children?: React.ReactNode;
        preload?: boolean;
    }

    export interface IMapState extends AnyObject {
        bounds?: number[][];
        center?: number[];
        controls?: string[];
        behaviors?: string[];
        margin?: number[] | number[][];
        type?: 'yandex#map' | 'yandex#satellite' | 'yandex#hybrid';
        zoom?: number;
    }

    export type YaMapCoordinatesType = [number, number];

    export type YaMapBoundsType = YaMapCoordinatesType[];

    export interface IUserGeoLocationEvent {
        geoObjects: {
            position: YaMapCoordinatesType;
        };
    }

    export interface IYaBoundsChangeEvent {
        originalEvent: {
            newZoom: number;
            newCenter: YaMapCoordinatesType;
            newBounds: YaMapBoundsType;
        };
    }

    export interface ITickEvent {
        originalEvent: {
            tick: {
                zoom: number;
            };
        };
    }

    export interface MapOptions extends AnyObject {
        autoFitToViewport?: 'none' | 'ifNull' | 'always';
        avoidFractionalZoom?: boolean;
        exitFullscreenByEsc?: boolean;
        fullscreenZIndex?: number;
        mapAutoFocus?: boolean;
        maxAnimationZoomDifference?: number;
        maxZoom?: number;
        minZoom?: number;
        nativeFullscreen?: boolean;
        projection?: any;
        restrictMapArea?: boolean;
        suppressMapOpenBlock?: boolean;
        suppressObsoleteBrowserNotifier?: boolean;
        yandexMapAutoSwitch?: boolean;
        yandexMapDisablePoiInteractivity?: boolean;
    }

    export interface MapProps extends CommonProps {
        state?: IMapState;
        defaultState?: IMapState;
        options?: MapOptions;
        defaultOptions?: MapOptions;
        children?: React.ReactNode;
        width?: number | string;
        height?: number | string;
        style?: React.CSSProperties;
        className?: string;
    }

    export interface ObjectManagerFeature {
        id: number | string;
        type: 'Feature';
        geometry: AnyObject;
        options?: AnyObject;
        properties?: AnyObject;
    }

    export interface ObjectManagerFeatureCollection {
        type: 'FeatureCollection';
        features: (ObjectManagerFeatureCollection | ObjectManagerFeature)[];
    }

    export type ObjectManagerFeatures =
        | (ObjectManagerFeatureCollection | ObjectManagerFeature)[]
        | ObjectManagerFeatureCollection;

    export type ObjectManagerFilter =
        | string
        | ((feature: ObjectManagerFeature) => void);

    export interface ObjectManagerOptions extends AnyObject {
        clusterize?: boolean;
        syncOverlayInit?: boolean;
        viewportMargin?: number | number[];
    }

    export type ObjectManagerObjectsOptions = AnyObject;
    export type ObjectManagerClustersOptions = AnyObject;

    export interface ObjectManagerProps extends CommonProps {
        features?: ObjectManagerFeatures;
        defaultFeatures?: ObjectManagerFeatures;
        filter?: ObjectManagerFilter;
        defaultFilter?: ObjectManagerFilter;
        options?: ObjectManagerOptions;
        defaultOptions?: ObjectManagerOptions;
        objects?: ObjectManagerObjectsOptions;
        defaultObjects?: ObjectManagerObjectsOptions;
        clusters?: ObjectManagerClustersOptions;
        defaultClusters?: ObjectManagerClustersOptions;
    }

    export interface ClustererOptions extends AnyObject {
        gridSize?: number;
        groupByCoordinates?: boolean;
        hasBalloon?: boolean;
        hasHint?: boolean;
        margin?: number | number[] | number[][];
        maxZoom?: number | number[];
        minClusterSize?: number;
        preset?: string;
        showInAlphabeticalOrder?: boolean;
        useMapMargin?: boolean;
        viewportMargin?: number | number[] | number[][];
        zoomMargin?: number | number[] | number[][];
    }

    export interface ClustererProps extends CommonProps {
        options?: ClustererOptions;
        defaultOptions?: ClustererOptions;
        children?: React.ReactNode;
    }

    export interface PanoramaOptions extends AnyObject {
        autoFitToViewport?: 'none' | 'ifNull' | 'always';
        controls?: string[];
        direction?: number[] | string;
        hotkeysEnabled?: boolean;
        scrollZoomBehavior?: boolean;
        span?: string | number[];
        suppressMapOpenBlock?: boolean;
    }

    export interface PanoramaProps extends CommonProps {
        coordinates?: number[];
        defaultCoordinates?: number[];
        options?: PanoramaOptions;
        defaultOptions?: PanoramaOptions;
        children?: React.ReactNode;
        width?: number | string;
        height?: number | string;
        style?: React.CSSProperties;
        className?: string;
    }

    export interface GeoObjectProps<G, P = AnyObject, O = AnyObject>
        extends AnyObject {
        geometry?: G;
        defaultGeometry?: G;
        properties?: P;
        defaultProperties?: P;
        options?: O;
        defaultOptions?: O;
    }

    export interface ControlProps<D = AnyObject, O = AnyObject, S = AnyObject>
        extends CommonProps {
        data?: D;
        defaultData?: D;
        options?: O;
        defaultOptions?: O;
        state?: S;
        defaultState?: S;
    }

    export interface WithYMapsProps {
        ymaps: IYMapsApi;
    }

    export function withYMaps<P>(
        component: React.ComponentType<P>,
        waitForApi?: boolean,
        modules?: string,
    ): React.ComponentType<P & WithYMapsProps>;

    export type GeoObjectGeometry = AnyObject;
    export type PlacemarkGeometry = number[];
    export type PolylineGeometry = number[][];
    export type RectangleGeometry = number[][];
    export type PolygonGeometry = number[][][];
    export type CircleGeometry = (number | number[])[];

    export const YMaps: React.ComponentType<YMapsProps>;
    export const Map: React.ComponentType<MapProps>;
    export const ObjectManager: React.ComponentType<ObjectManagerProps>;
    export const Clusterer: React.ComponentType<ClustererProps>;
    export const Panorama: React.ComponentType<PanoramaProps>;

    export const GeoObject: React.ComponentType<
        GeoObjectProps<GeoObjectGeometry>
    >;
    export const Placemark: React.ComponentType<
        GeoObjectProps<PlacemarkGeometry>
    >;
    export const Polyline: React.ComponentType<
        GeoObjectProps<PolylineGeometry>
    >;
    export const Rectangle: React.ComponentType<
        GeoObjectProps<RectangleGeometry>
    >;
    export const Polygon: React.ComponentType<GeoObjectProps<PolygonGeometry>>;
    export const Circle: React.ComponentType<GeoObjectProps<CircleGeometry>>;

    export const Button: React.ComponentType<ControlProps>;
    export const FullscreenControl: React.ComponentType<ControlProps>;
    export const GeolocationControl: React.ComponentType<ControlProps>;
    export const ListBox: React.ComponentType<ControlProps>;
    export const ListBoxItem: React.ComponentType<ControlProps>;
    export const RouteButton: React.ComponentType<ControlProps>;
    export const RouteEditor: React.ComponentType<ControlProps>;
    export const RoutePanel: React.ComponentType<AnyObject>;
    export const RulerControl: React.ComponentType<ControlProps>;
    export const SearchControl: React.ComponentType<ControlProps>;
    export const TrafficControl: React.ComponentType<AnyObject>;
    export const TypeSelector: React.ComponentType<AnyObject>;
    export const ZoomControl: React.ComponentType<ControlProps>;
}
