## Гайд по работе с цветами

Все цвета должны быть взяты из дизайнерских гайдов: https://nda.ya.ru/3UZpVa

### Если цвета в дизайне нет в гайдах:

-   Попросим дизайнера добавить цвет в гайды
-   Добавляем цвет в файл `lightThemeColors.scss`. Чтобы дать название переменной добавляем к названию цвета приставку `light`. Допустимые значения цвета:
    -   hex (Пример: #000)
    -   rgba (Примеры: rgba(#000, 0.0), rgba($var, 0.0), rgba(), реже rgba(255, 51, 51, 0.12)),
    -   linear-gradient, radial-gradient
    -   другая saas-переменная
-   Создаем css переменную в `colors.scss` . Переменная будет ссылаться на sass переменную с аналогичным названием из `lightThemeColors.scss`, а к имени css переменной добавляется префикс: `--yatravel-`. Именно css переменную в дальнейшем используем в компонентах.

<details>
<summary>Пример добавления новой переменной цвета</summary>

-   В файле _lightThemeColors.scss:_

`$light-bg-newColor-default-hover-color: #111; // Приставка *light + название цвета`

-   В файле _colors.scss:_

`--yatravel-bg-newColor-default-hover-color: #{$light-bg-newColor-default-hover-color}; // Приставка --ya-travel- + название цвета`

-   В компоненте _components/NewFeature.scss_

`background-color: var(--yatravel-bg-newColor-default-hover-color);`

</details>

### Как придумать название для цвета

Название для цвета состоит из следующих частей (порядок важен):

-   [не обязательное] `bg/border` обводка или заливка. Несмотря на то, что эта часть не обязательная, почти у всех контролов она есть. Исключение составляют цвета ссылок и текста.
    -   Пример: есть кнопка, у которой есть обводка и заливка. Цвет обводки будет начинаться с bg, цвет заливки с border
    -   Пример: есть линия-разделитель. Ее цвет начинается с border, у нее нет парного цвета, который начинался бы с bg
-   [обязательное] `control` сущность, для которой применяется цвет (Кнопка, текст, ссылка)
-   [обязательное] `theme` тема. Если предполагается, что тема у контрола одна - используется слово default
-   [необязательное] `состояние` Привычные hover, focused, disabled, etc
-   [обязательное] `color/gradient` Отражает суть значения: цвет это или градиент
