## CSRF token

Для того чтобы получить значение токена для запроса нужно прочитать его из объектв `csrf` экспортируемого модулем `createGlobalTokenGetter`:

```js
import {csrf} from 'utilities/csrfToken/createGlobalTokenGetter';

function createAxios() {
    return axios.create({
        baseURL: '/api/trains',
        headers: csrf.tokenHeader,
    });
}
```

Значение токена будет доступно после выполнения кода `client.js`, поэтому не стоит пытаться его прочесть при инициализации модуля, лучше всего его читать при отправке запроса.

## Устаревшие способы получения токена

-   Напрямую из редакса с помощью селектора в экшенах
-   Напрямую из редакса с помощью генератора в сагах
-   Путем проставления куки

Токен должен подставляться клиентским кодом отвечающим за запросы к контроллерам.

> **NB** Планируется что для клиентских запросов будет использоваться общая обертка над `axios`, впоследствие она и только она будет отвечать за чтение токена.
