## Работа с дизайном

Посмотреть макеты можно в [нашей фигме](https://www.figma.com/files/project/1563705/Travel).

Кроме того у нас есть [style-guide](https://www.figma.com/file/I8EBpOVkBHKTHVrDyWuaaIhI/Travel.Styles?node-id=0%3A1).

### Цвета

1. При разработке должны использоваться цвета из файла `src/styles/colors.scss` - имена этих цветов совпадают с именами цветов в гайде. Цвета импортируется через общий импорт `src/styles/variables.scss`.

2. Писать литералы цветов прямо в css нельзя.

#### FAQ по цветам

> Что делать, если я редактирую старый файл с цветами не из `src/styles/colors.scss`?

1. Используешь общий компонент, вместо частного решения из src/components (обычно потребность в цвете отпадает) и призываешь дизайнера в ревью.
2. Открываешь тред с дизайном, что здесь лучше сделать, ну и можно договориться, что по факту решения в треде заводится задача, к этой строчке кода приписывается игнор и тудушка с номером тикета

> Что делать, если в макете присутствует цвет, которого нет в гайде?

Напишите вопрос дизайнеру. Новые цвета добавляются в `src/styles/colors.scss` только после добавления их в дизайнерский style-guide.

> В `src/styles/variables.scss` тоже есть цвета

Цвета, которые прописаны в `variables.scss`, помечены как deprecated, с ними есть ряд проблем и они постепенно будут выпилены.

### Тени

Тени описываются в общем файле `src/styles/shadows.scss` и должны соответсвовать теням в гайде. Тени импортируется через общий импорт `src/styles/variables.scss`.
