## Встраивание в приложения Яндекс Авиабилеты и Яндекс Путешествия

Портал встраивается в приложения на Android и iOS через WebView

### Концепция

При встраивании в приложение мы скрываем элементы, которые позволяют выйти со страницы: баннеры, ссылки, шапку, футер.
Некоторые функциональные ссылки заменяем на событие для приложения, чтобы открыть их в браузере на телефоне пользователя.
Отправляем другие необходимые для работы события в приложение.

### Реализация

По заголовкам определяем в middleware [platformMiddleware](../server/middlewares/platformMiddleware.ts) и [isTravelAppMiddleware](../server/middlewares/isTravelAppMiddleware.ts)
определяем, что мы встроены в приложение.

Полученные параметры пробрасываем до redux state, дальше используем флаги в верстке для изменений только при встраивании

-   `isWeb === true` - когда мы не встроены ни в какое приложение;
-   `isTravelApp === true` - встроены именно в TravelApp, отделили так как бронирование авиа отличается в этих приложениях;

[PlatformContext](../src/contexts/PlatformContext.ts)

### Встраиваемый функционал

Приложение Яндекс Авиабилеты

-   Страница поиска авиабилетов
-   Бронирование осуществляется во встроенном браузере

Приложение Яндекс Путешествия

-   Страница "Мои поездки"
-   Страницы "Избранное"
-   Страница "Отель"
-   Бронирование отеля
-   Страница "Вариант перелета"
-   Бронирование авиа

### Оплата

В TravelApp оплата реализована через APP SDK траста, поэтому мы не рисуем форму траста,
только передаем purchase_token в приложение, по вот такой [схеме](https://st.yandex-team.ru/TRAVELFRONT-7661#623ed02bd9f9310330de1349)
