# Avia. Redirects

На страницу редиректа можно попасть:

-   с колдуна
-   со страницы поиска (при клике по кнопке купить)
-   со страницы покупки (при клике по предложению партнёра)

Есть два типа редиректов:

-   быстрый (`instant redirect`)
-   долгий (`long redirect`)

Входная точка для редиректов:

-   url `/avia/redirect/`
-   код `/server/redux/avia/aviaRedirectPageController`

### Instant redirect

Быстрый редирект осуществляется для пользователей пришедших с колдуна, либо для пользователей попавших в эксперимент (быстрый редирект ограничен для ряда партнёров, которые задаются в переменной окружения `AVIA_NOT_INSTANT_PARTNERS`).
"Быстрый" т.к. не поисходит инициализация поиска, обращение к бекенду происходят без перезапросов.
Если упростить - сходили в бекенд, получили ссылку на партнёра, перенаправили пользователя на сайт партнёра.
Если при быстром редиректе произошла ошибка, то в качестве фолбека будет выбран долгий редирект.

### Long redirect

Долгий редирект предполагает ряд проверок и опросов бекенда и т.к. это может занять продолжительное время, то редирект имеет интерфейсное представление (страница с прогресс баром).
При заходе по урлу происходит ряд базовых проверок (если какая-либо проверка не пройдена - редиректим на страницу ошибки), обновляется qid (идентификатор поиска) и в store записывается необходимая информация:

-   `qid`
-   `partner`
-   `redirectUrl` - ссылка на ручку, которая редиректит пользователя к партнеру, либо на страницу ошибки редиректа
-   `errorRedirectUrl` - ссылка на страницу ошибки редиректа

После этого возвращаем пользователю страницу с прогресс баром (`src/projects/avia/pages/AviaRedirect/index`).

![long-redirect-page](long-redirect.png)

На клиенте мы начинаем опрос бекенда (если в процессе опроса бекенд вернул `4XX` код ответа, то для последующих запросов выставляем параметр `book_on_yandex=false`), ищем в ответе бекенда варианты удовлетворяющие параметрам страницы редиректа (с багажом или без).
Если не нашли вариант - средиректим пользователя на страницу ошибки (по `errorRedirectUrl`).
Если нашли вариант - средиректим пользователя в api (по `redirectUrl`).

В случае ошибки в ручке, пользователя средиректит на страницу ошибки, в случае успеха возможны два варианта:

-   если в ответе ручки редиректа был параметр `post`, то мы вернём пользователю страницу с формой, которая автоматически засабмитится и перенесёт пользователя на страницу партнёра
-   если в ответе ручки редиректа не было параметра `post`, то сами средиректим пользователя на страницу партнёра

Код:

-   `/server/conrollers/aviaApiController/AviiaRedirectController`
-   `/server/services/AviaRedirectService`

### Страница ошибки редиректа

Переход на страницу ошибки редиректа осуществляется в случае невалидного урла редиректа либо ошибки при взаимодействии с бекендом.

-   url `/avia/redirect/error`
-   код `/server/avia/redirectErrorController`

При обработке запроса на страницу ошибки редиректа есть вероятность, что пользователь будет направлен обратно на страницу покупки.
Редирект на страницу покупки произойдёт только в том случае если по данному рейсу есть другие партнёры. После редиректа пользователь попадает на
страницу покупки с параметрами `fromError` и `partner`, указанный в параметре `partner` партнёр будет исключен из списка предложений (блок с ссылками на партнёров).

![order-page-with-error](order-page-with-error.png)

Если по данному рейсу был только один прартнёр, то редирект на страницу покупки не произойдет и пользователю будет показана страница ошибки редиректа.

![error-page](error-page.png)
