# Запуск тестов для тестировщиков

Запуск тестов на ОС Windows

## Необходимое ПО

1. [NodeJS 12.x](https://nodejs.org/download/release/v12.22.8/) (суффикс x86.msi/x64.msi для 32/64)
2. [Git](https://git-scm.com/)
3. [IDE WebStorm](https://www.jetbrains.com/ru-ru/webstorm/) (или любой другой аналог)

## Установка зависимостей для сборки npm пакетов

**В Windows требуется запускать в терминале WebStorm (от администратора) или в командной строке с правами администратора**

Необходимые инструменты сборки:

1. [node-gyp](https://github.com/nodejs/node-gyp)

```
npm install -g node-gyp
```

### Только для Windows:

2. [windows-build-tools](https://github.com/felixrieseberg/windows-build-tools)

```
npm install -g windows-build-tools
```

_В случае ошибок или зависаний установки стоит попробовать перезагрузить ПК_

## Клонирование проекта

Установить Аркадию https://a.yandex-team.ru/arcadia/travel/frontend/portal/docs/to-arcadia.md

## Установка зависимостей проекта

Перейти в корневую папку проекта `portal`.
_При открытии терминала в WebStorm, папка `portal` открывается по умолчанию._

Установить зависимости проекта:

```
npm i
```

Установить зависимости проекта с тестами:

Перейти в папку `integration`:

```
cd integration
```

Затем

```
npm i
```

## Директория с проектом тестов

Все дальнейшие действия будем проводить в папке `integration`

```
cd integration
```

## Настройка переменных окружения

В папке `integration` создайте файл `.env.dev` и заполните его следующим содержимым:

```
NODE_PATH=..
E2E_ENV=dev
E2E_URL=https://travel-test.yandex.ru/
E2E_RETRIES=0
E2E_OAUTH_TOKEN=ТОКЕН
```

где,

-   E2E_URL - адрес сервиса куда пойдут тесты
-   E2E_RETRIES - количество повторных запусков каждого теста, 0 повторов для написания тестов самое то
-   E2E_OAUTH_TOKEN - токен для создания тестовых записей в паспорте, получите по [ссылке](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=9052de6e4cf142039a7ee44ac03e4614)

## Запуск тестов

Чтобы запустить все тесты, которые есть в папке tests

```
npm run test:e2e:dev
```

Чтобы запустить конкретные тесты, добавьте аргумент `grep`,
запустятся все тесты подходящие под указанную маску.

`npm run test:e2e:dev -- --grep="Работа популярных ж/д направлений"`

Чтобы запустить тесты в определенном браузере, добавьте аргумент `browser` (название браузера можно посмотреть в отчете или выводе запуска):

`npm run test:e2e:dev -- --browser="chrome 77.0"`

## Troubleshooting

Сюда будут записываться известные проблемы и пути их решения.

1. Иногда возникают проблемы при установке windows-build-tools. Например, виснет установка при попытке поставить Python. Решений может быть несколько:

-   Самое простое - неделать ничего, а подождать с момента зависания минут 10, а затем перейти к следующему шагу (не проверено, потому что было заблокировано багом с hermione)

-   Ещё один вариант - запустить установку build-tools через лаунчер. Он располагается по адресу `C:\Users\<username>\.windows-build-tools` и называется `vs_BuildTools.exe`

-   Один из вариантов подсказал Интернет: Если ранее стоял Питон, то его необходимо снести через Установку и удаление программ (где-то на Панели управления спрятано), а затем запустить установку windows-build-tools

-   Ещё вариант из Интернета: вместо команды из доки использовать `npm install --global --production windows-build-tools@4.0.0` (работает, проверено)

-   Комбинация вариантов (ну а вдруг???)

Что-то из этого мне помогло. Автор: gouken67 (совместно с isaven)
