import {camelCase, upperFirst} from 'lodash';
import {EExportMode, IFriggaOptions} from '@yandex-data-ui/frigga';

const RASTER_ILLUSTRATIONS_RE =
    /^RasterIllustration\s*\/\s*(?<name>[^/\s]+)\s*\/\s*(?<size>.*)$/;

export const file: IFriggaOptions['file'] = 'I8EBpOVkBHKTHVrDyWuaaIhI';

export const select: IFriggaOptions['select'] = ({name}) => {
    return RASTER_ILLUSTRATIONS_RE.test(name);
};

export const getFileName: IFriggaOptions['getFileName'] = component => {
    const matchResult = RASTER_ILLUSTRATIONS_RE.exec(component.name);

    if (!matchResult || !matchResult.groups) {
        throw new Error('Unexpected component name');
    }

    const {size, name} = matchResult.groups;

    return `${size}/${name}.tsx`;
};

export const getComponentName: IFriggaOptions['getComponentName'] =
    component => {
        const matchResult = RASTER_ILLUSTRATIONS_RE.exec(component.name);

        if (!matchResult || !matchResult.groups) {
            throw new Error('Unexpected component name');
        }

        const {name} = matchResult.groups;

        return upperFirst(camelCase(name)) + 'Image';
    };

export const exportMode: IFriggaOptions['exportMode'] = EExportMode.PNG;

export const exportScale: IFriggaOptions['exportScale'] = 2;

export const exportPngTemplate: IFriggaOptions['exportPngTemplate'] =
    "import React from 'react';\n" +
    '\n' +
    "import src from 'IMAGE_PATH';\n" +
    '\n' +
    'const IMAGE_COMPONENT_NAME: React.FC<\n' +
    '    Omit<\n' +
    '        React.DetailedHTMLProps<\n' +
    '            React.ImgHTMLAttributes<HTMLImageElement>,\n' +
    '            HTMLImageElement\n' +
    '        >,\n' +
    "        'src'\n" +
    '    >\n' +
    '> = props => {\n' +
    "    const {alt = 'IMAGE_COMPONENT_NAME', ...rest} = props;\n" +
    '\n' +
    '    return <img {...rest} src={src} alt={alt} />;\n' +
    '};\n' +
    '\n' +
    'export default IMAGE_COMPONENT_NAME;\n';
