const {sets} = require('./.hermione.conf');
const {formats} = require('@yandex-int/palmsync');

const hermioneToPalmTitle = title => title.replace(': ', ' / ');

module.exports = {
    project: process.env.TESTPALM_PROJECT,

    synchronizationOpts: {
        attachBugFilterLinkToTestCasePreconditions: false,
        attachSkippedTestsToTestCaseDescription: false,
    },
    hermioneConfigPath: '.hermione.conf.js',

    filePatterns: {
        yaml: /\.testpalm\.yaml$/,
        hermione: /\.hermione\.js$/,
    },

    sets: {
        yaml: {
            desktop: {
                specs: [
                    'tests/desktop/**/*.testpalm.yaml',
                    'tests/cases/desktop/**/*.testpalm.yaml',
                ],
                envs: [
                    {
                        PLATFORM: 'desktop',
                    },
                ],
                browsers: sets.desktop.browsers,
                baseUrl: '/',
            },
            touch: {
                specs: [
                    'tests/touch/**/*.testpalm.yaml',
                    'tests/cases/touch/**/*.testpalm.yaml',
                ],
                envs: [
                    {
                        PLATFORM: 'touch',
                    },
                ],
                browsers: sets.touch.browsers,
                baseUrl: '/',
            },
            common: {
                specs: [
                    'tests/common/**/*.testpalm.yaml',
                    'tests/cases/common/**/*.testpalm.yaml',
                ],
                envs: [
                    {
                        PLATFORM: 'common',
                    },
                ],
                browsers: sets.common.browsers,
                baseUrl: '/',
            },
        },
    },

    // Матчинг сценариев и тестов происходит по заголовкам
    // Чтобы не зависеть от форматирования заголовков - отбрасываем не алфавитно-цифровые символы
    // Пример:
    // Заголовок теста: "Поезда: Главная Популярные направления соотвествуют геолокации пользователя"
    // Заголовок сценария: "Поезда / Главная Популярные направления соотвествуют геолокации пользователя"
    fullTitleComparator: ({fullTitle}, hermioneTestTitle) => {
        return fullTitle === hermioneToPalmTitle(hermioneTestTitle);
    },

    // Секция необходима для исключения тестов, которые не должны быть синхронизированы с TestPalm
    excludes: {
        hermione: ['tests/**/utils/**', 'tests/**/no_yaml/**'],
    },
    // Список плагинов для обработки событий синхронизации
    plugins: {
        'palmsync-testcase-format-plugin': {},
    },
    // Описание кастомных полей для тестовых сценариев
    schemeExtension: [
        {
            name: 'Сервис',
            required: true,
            meta: true,
        },
        {
            name: 'Страница',
            required: false,
            meta: true,
            format: formats.isStringOrArrayOfStrings,
            /*format: formats.isEnum
            (
                'Выдача',
                'Главная',
                'Пассажиры',
                'Билеты и бронирования',
                'Страница заказа',
                'Оплата',
                'Подтверждение',
                'Ввод данных',
                'Выбор мест',
                'Бронирование',
                'Поиск',
                'Покупка',
                'Колдунщик',
                'Страница покупки',
                'Партнеры',
                'Страница отеля',
                'Happy page',
                'Страница города',
            ),
            */
        },
        {
            name: 'Устройство',
            required: false,
            meta: true,
            format: formats.isStringOrArrayOfStrings,
            //format: formats.isArrayOfEnums('Тач', 'Десктоп'),
        },
        {
            name: 'Окружение',
            required: false,
            meta: true,
            format: formats.isStringOrArrayOfStrings,
            //format: formats.isArrayOfEnums('Production', 'Testing'),
        },
        {
            name: 'Функциональность',
            required: false,
            meta: true,
        },
        {
            name: 'Тестирование асессорами',
            required: false,
            meta: true,
            format: formats.isEnum('Да', 'Нет'),
        },
        {
            name: 'Tag',
            required: false,
            meta: true,
        },
        {
            name: 'Автор',
            required: false,
            meta: true,
        },
        {
            name: 'system',
            required: false,
            meta: true,
        },
        {
            name: 'manual',
            required: false,
            meta: true,
        },
        {
            name: 'tlds',
            required: false,
            meta: true,
        },
    ],
    // https://a.yandex-team.ru/arcadia/frontend/projects/infratest/packages/palmsync/docs/configuration.md#testcasedecorator
    // убрано, потому что дублирует выгружаемый из пальмсинка ключ files
    /*testCaseDecorator: testCase => {
        const files = testCase.getField('files');
        const description = testCase.getField('description');

        // Один и тот же тест может попадать в testCaseDecorator несколько раз,
        // поэтому проверяем, что мы не меняли заголовок
        if (
            files &&
            files.length &&
            description &&
            !description.includes(GITHUB_PROJECT_URL)
        ) {
            testCase.setField(
                'description',
                `${[
                    description,
                    ...files.map(file => `Тест: ${GITHUB_PROJECT_URL}${file}`),
                ].join('\n')}`,
            );
        }
    },*/
};
