/* eslint-disable @typescript-eslint/naming-convention */

declare namespace Hermione {
    interface TestDefinitionCallbackCtx {
        /**
         * Наша доработка
         * Сами патчим это значение в hermione-global-hook
         */
        retryCount: number;
    }
}

declare namespace WebdriverIO {
    interface Browser {
        /**
         * Наши доработки добавленные через commands
         */
        switchToNextTab(): Promise<void>;
        switchToPreviousTab(): Promise<void>;
        login(login: string, password: string): Promise<void>;
        getBrowserName(): Promise<'firefox' | 'chrome' | 'opera' | null>;
        clickJS(selector: string): Promise<void>;

        /**
         * Настройки для браузера
         */
        requestedCapabilities: {
            'goog:chromeOptions': {mobileEmulation: unknown};
        };
    }
}

declare interface IWDIOCssProperty {
    property: string;
    value: number | string;
    parsed: object;
}

interface IComponent {
    path: string[];
    qa: string;
}

interface IObjectQAValue {
    /**
     * Ключ элемента в списке
     */
    key?: string | number;
    /**
     * qa родителя
     */
    parent?: string | IComponent;
    /**
     * qa текущего элемента
     */
    current?: string | null;
    /**
     * вложенность элемента в DOM дереве
     */
    path?: string[];
}

declare type QA = string | IObjectQAValue;

declare type NestedQA = string | string[];

declare namespace Chai {
    export interface Assert {
        exists<T>(value: T, message?: string): asserts value is NonNullable<T>;
    }
}
