## Настройки

Настроить инструмент можно двумя способами:

-   можно использовать статичный конфиг `.e2e.json`, который позволяет настроить как `dev`, так и `testing` окружение.
-   можно передать при запуске переменные окружения.

Переменные окружения переопределяют статичный конфиг.

| Параметр                                                               | Переменная окружения | Обязательный | Описание                                                                                                                                            |
| ---------------------------------------------------------------------- | -------------------- | ------------ | --------------------------------------------------------------------------------------------------------------------------------------------------- |
| -                                                                      | `E2E_VERBOSE`        | ✓            | Переменная окружения, которая включает вывод разной отладочной информации для дебага.                                                               |
| -                                                                      | `E2E_ENV`            | ✓            | Переменная окружения, которая настраивает какой конфиг надо использовать.                                                                           |
| -                                                                      | `E2E_URL`            | ✓            | Переменная окружения, которая настраивает какой урл на котором развернуто ваше приложение, например для девелопмпента `https://user.ui.yandex.ru/`. |
| `passportEnv`                                                          | `E2E_PASSPORT_ENV`   |              | Какой использовать паспорт для аутентификации пользователя. По умолчанию используется тестовый паспорт.                                             |
| `retries`                                                              | `E2E_RETRIES`        |              | Количество перезапусков для каждого теста.                                                                                                          |
| `reportPath`                                                           | `E2E_REPORT_PATH`    |              | Путь по которому будет создан html отчет.                                                                                                           |
| `sets`                                                                 | -                    |              | Конфигурация браузеров для каждого из тест-сетов `common`, `desktop`, `touch`                                                                       |
| `sets.common.browsers`, `sets.desktop.browsers`, `sets.touch.browsers` | -                    |              | Список браузеров - возможные значения `chrome`, `firefox`, `opera`, `yandex`, `chrome_ios_phone`, `chrome_ios_tablet`, `chrome_android_phone`.      |

## Локальный запуск

Из коробки поддерживается браузер `chrome`.
Переменные окружения беруться из файла `.env.standalone`. Статические настройки из поля `standalone`.

```bash
npm run test:e2e:standalone
```

## Утилиты для браузера

[Интерфейс и функция](client/qaAttributes/README.md) для работы с qa атрибутами в браузере.

## Плагины

Набор собственных [плагинов](plugins/plugins.md).
