export default function (browser: WebdriverIO.Browser): void {
    browser.addCommand('clickJS', async (selector: string): Promise<void> => {
        await browser.execute(_selector => {
            const element = document.querySelector(_selector);

            if (element instanceof HTMLElement) {
                element.click();
            } else if (element instanceof SVGElement) {
                const clickEvent = new MouseEvent('click', {
                    bubbles: true,
                    cancelable: true,
                });

                element.dispatchEvent(clickEvent);
            }
        }, selector);

        // иногда браузер почему-то не мгновенно реагирует на js клик
        await browser.pause(1000);
    });
}
