import prepareQaSelector from './utils/qa';

export default function (browser: WebdriverIO.Browser): void {
    /**
     * Авторизует пользователя в нужном паспорте
     */
    browser.addCommand(
        'login',
        async (login: string, password: string): Promise<void> => {
            const meta = await browser.getMeta();

            if (!(login && password && meta.hasOwnProperty('baseUrl'))) {
                throw new Error(
                    'Command "login" failed, property "login" or "password" or "baseURL" is undefined.',
                );
            }

            await browser.setMeta('login', login);
            await browser.setMeta('password', password);

            const {passportEnv, baseUrl} = meta;

            const passportDomain =
                passportEnv === 'testing'
                    ? 'passport-test.yandex.ru'
                    : 'passport.yandex.ru';
            const passportUrl = `https://${passportDomain}/auth?mode=password&retpath=${encodeURIComponent(
                baseUrl as string,
            )}`;

            const timestamp = Math.round(new Date().getTime() / 1000);
            const html = `
                    <html>
                        <form method="POST" action="${passportUrl}">
                            <input name="login" value="${login}">
                            <input name="passwd" value="${password}">
                            <input type="checkbox" name="twoweeks" value="no">
                            <input type="hidden" name="timestamp" value="${timestamp}">
                            <button type="submit" data-qa="passport-form-submit">Login</button>
                        </form>
                    <html>
                `;

            const base64 = Buffer.from(html).toString('base64');

            await browser.url('data:text/html;base64,' + base64);

            const submitElement = browser.$(
                prepareQaSelector('passport-form-submit'),
            );

            await submitElement.click();
        },
    );
}
