export default function (browser: WebdriverIO.Browser): void {
    async function switchToTabRelative(offset: number): Promise<void> {
        const currentHandle = await browser.getWindowHandle();
        let handles = await browser.getWindowHandles();

        const currentIndex = handles.indexOf(currentHandle);

        let nextTabPosition = currentIndex + offset;

        // в опере какая-то левая вкладка затесывается между нулевой и новой открытой перешагиваем через нее
        if ((await browser.getBrowserName()) === 'opera') {
            if (offset > 0 && currentIndex === 0) {
                nextTabPosition++;
            }

            if (offset < 0 && currentIndex === 2) {
                nextTabPosition--;
            }
        }

        if (nextTabPosition < 0) {
            throw new Error('nextTabPosition is negative');
        }

        if (nextTabPosition >= handles.length) {
            // Если в списке табов не появился новый таб - даём немного времени чтоб это произошло
            await browser.pause(500);

            handles = await browser.getWindowHandles();
        }

        if (nextTabPosition >= handles.length) {
            // Таб так и не появился - выбрасываем исключение
            throw new Error("New tab didn't open");
        }

        await browser.switchToWindow(handles[nextTabPosition]);

        // firefox не сразу выставляет url страницы
        if ((await browser.getBrowserName()) === 'firefox') {
            await browser.pause(500);
        }
    }

    browser.addCommand('switchToNextTab', async () => {
        await switchToTabRelative(1);
    });

    browser.addCommand('switchToPreviousTab', async () => {
        await switchToTabRelative(-1);
    });
}
