/* DO NOT EDIT THIS FILE */
const TEST_EXECUTION_TIMEOUT = 2 * 60 * 1000;

function getSystemConfiguration({workersCount}) {
    const config = {
        mochaOpts: {
            timeout: TEST_EXECUTION_TIMEOUT,
        },
        patternsOnReject: [
            /timeout/i,
            /timedout/i,
            /timed out/i,
            /It may have died/,
            /CLIENT_STOPPED_SESSION/,
            /was terminated due to CLIENT_GONE/,
            /cannot forward the request/,
            /FORWARDING_TO_NODE_FAILED/,
            /PROXY_REREGISTRATION/,
            /not available and is not among the last/,
            /The specified window could not be found/,
            /ESOCKETTIMEDOUT/,
            /route not found/,
        ],
        fileExtensions: ['.ts'],
    };

    if (workersCount > 0) {
        config.workers = workersCount;
    }

    return config;
}

module.exports = {
    getSystemConfiguration,
};
