import {TFieldParams} from 'helpers/project/common/form/formFields';

import {Page} from 'components/Page';
import {Button} from 'components/Button';
import {Component} from 'components/Component';
import {Form} from 'components/Form';
import PassengerInfo from './components/PassengerInfo';
import Documents from './components/Documents';
import Passengers from './components/Passengers';

export default class PassengersPage extends Page {
    addPassengerButton: Button;
    emptyAddPassengerButton: Button;
    passengerPageLoading: Component;
    passengerAddForm: Form;

    passengerInfo: PassengerInfo;
    documents: Documents;
    passengers: Passengers;

    constructor(browser: WebdriverIO.Browser) {
        super(browser);

        this.addPassengerButton = new Button(browser, 'passenger-list-add');
        this.emptyAddPassengerButton = new Button(
            browser,
            'empty-passenger-list-add',
        );

        this.passengerPageLoading = new Component(
            browser,
            'passenger-page-loading',
        );

        this.passengerAddForm = new Form(
            browser,
            'passenger-add-form',
            'passenger-add-form-submit',
        );

        this.passengerInfo = new PassengerInfo(browser);
        this.documents = new Documents(browser);
        this.passengers = new Passengers(browser, {
            parent: 'passenger-list',
            current: 'item',
        });
    }

    /*
     * Passenger actions
     */

    /**
     * Функция добавления пассажира
     * ВНИМАНИЕ: форму с полями и нужной QA отбивкой надо предварительно открыть
     * Есть проверка на успешное добавление пассажира
     * смотрит есть ли кнопка удаления и совпадает ли номер документа с введенным
     *
     * @param {{id: string, type: string, value: string}[]} fields
     * @param {boolean} isFirst
     * @return {true | Error}
     */
    async addPassenger(
        fields: TFieldParams[],
        isFirst: boolean,
    ): Promise<void> {
        await this.waitPageLoadingEnd();

        const addPassengerButton = isFirst
            ? this.emptyAddPassengerButton
            : this.addPassengerButton;

        await addPassengerButton.click();
        await this.passengerAddForm.fill(fields);
        await this.passengerAddForm.submit();

        await this.waitPageLoadingEnd();
    }

    async editPassenger(fields: TFieldParams[]): Promise<void> {
        await this.waitPageLoadingEnd();

        await this.passengerInfo.editPassenger(fields);

        await this.waitPageLoadingEnd();
    }

    async removeAllPassengers(): Promise<void> {
        try {
            const passengers = await this.passengers.items;

            for (const passenger of passengers) {
                await passenger.click();

                await this.passengerInfo.removePassenger();
            }
        } catch (e) {
            console.error(e);
        }
    }

    async openPassenger(index: number): Promise<void> {
        const passenger = await this.passengers.at(index);

        passenger.click();
    }

    async closePassenger(): Promise<void> {
        if (this.isDesktop) {
            return;
        }

        await this.passengerInfo.backButton.click();
    }

    async waitPageLoadingEnd(): Promise<void> {
        try {
            await this.passengerPageLoading.waitForVisible();
            await this.passengerPageLoading.waitForHidden(15000);
        } catch {}
    }
}
