import {Component} from 'components/Component';
import {Button} from 'components/Button';

export default class Document extends Component {
    type: Component;
    nameBig: Component;
    nameSmall: Component;
    number: Component;
    citizenship: Component;
    expirationDate: Component;
    loader: Component;
    edit: Button;
    remove: Button;
    removeConfirm: Button;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa);

        this.type = new Component(browser, {parent: this.qa, current: 'type'});
        this.nameBig = new Component(browser, {
            parent: this.qa,
            current: 'name-big',
        });
        this.nameSmall = new Component(browser, {
            parent: this.qa,
            current: 'name-small',
        });
        this.number = new Component(browser, {
            parent: this.qa,
            current: 'number',
        });
        this.citizenship = new Component(browser, {
            parent: this.qa,
            current: 'citizenship',
        });
        this.expirationDate = new Component(browser, {
            parent: this.qa,
            current: 'expiration-date',
        });

        this.loader = new Component(browser, {
            parent: this.qa,
            current: 'loading',
        });

        this.edit = new Button(browser, {parent: this.qa, current: 'edit'});
        this.remove = new Button(browser, {parent: this.qa, current: 'remove'});
        this.removeConfirm = new Button(browser, {
            parent: this.qa,
            current: 'dialog-submit',
        });
    }

    async getData(): Promise<{
        [key: string]: string | undefined;
    }> {
        return {
            type: await this.type.getText(),
            nameBig:
                (await this.nameBig.getText().catch(() => undefined)) ||
                undefined,
            nameSmall:
                (await this.nameSmall.getText().catch(() => undefined)) ||
                undefined,
            number: await this.number.getText(),
            citizenship: await this.citizenship.getText(),
            expirationDate: await this.expirationDate
                .getText()
                .catch(() => undefined),
        };
    }

    async waitForLoadingEnd(): Promise<void> {
        try {
            await this.loader.waitForVisible();
            await this.loader.waitForHidden();
        } catch {}
    }
}

module.exports = Document;
