import {TFieldParams} from 'helpers/project/common/form/formFields';

import {Component} from 'components/Component';
import {Button} from 'components/Button';
import {Form} from 'components/Form';

export default class PassengerInfo extends Component {
    title: Component;
    birthdate: Component;
    gender: Component;
    itn: Component;
    editButton: Button;
    removeButton: Button;
    removeConfirm: Button;
    backButton: Button;
    details: Component;
    form: Form;

    constructor(browser: WebdriverIO.Browser) {
        super(browser);

        this.title = new Component(browser, 'passenger-info-title');
        this.birthdate = new Component(browser, 'passenger-info-birthdate');
        this.gender = new Component(browser, 'passenger-info-gender');
        this.itn = new Component(browser, 'passenger-info-itn');

        this.editButton = new Button(browser, 'passenger-edit-button');
        this.removeButton = new Button(browser, 'remove-passenger');
        this.removeConfirm = new Button(browser, 'account-remove-confirmation');
        this.backButton = new Button(browser, 'passenger-info-backButton');
        this.details = new Component(browser, 'passenger-details');

        this.form = new Form(
            browser,
            'passenger-edit-form',
            'passenger-edit-form-submit',
        );
    }

    async editPassenger(fields: TFieldParams[]): Promise<void> {
        await this.editButton.click();
        await this.form.fill(fields);
        await this.form.submit();
    }

    async getData(): Promise<{
        title: string;
        birthdate: string;
        itn: string | undefined;
        gender: string;
    }> {
        const title = await this.title.getText();
        const birthdate = await this.birthdate.getText();
        const genderText = await this.gender.getText();
        const itn = await this.itn.getText().catch(() => undefined);

        return {
            title,
            birthdate,
            itn,
            gender: genderText[0],
        };
    }

    async removePassenger(): Promise<void> {
        await this.removeButton.waitForVisible();

        await this.removeButton.click();
        await this.removeConfirm.click();
    }
}
