import {Input} from 'components/Input';
import {ComponentArray} from 'components/ComponentArray';

import Passenger from './Passenger';

export default class Passengers extends ComponentArray<Passenger> {
    searchInput: Input;

    constructor(browser: WebdriverIO.Browser, qa: QA) {
        super(browser, qa, Passenger);

        this.searchInput = new Input(browser, 'passengers-search-input');
    }

    async findPassengerByTitle(title: string): Promise<Passenger | undefined> {
        return await this.find(async passenger => {
            const passengerTitle = await passenger.title.getText();

            return passengerTitle === title;
        });
    }
}
