import {IPassengerInfoRealData} from '../types/formFields';

import {TFieldParams} from 'helpers/project/common/form/formFields';

import {preparePassengerInfoFieldsData} from './prepareFieldsData';

export default function isPassengerInfoEqual(
    dataSet: TFieldParams[],
    realData: IPassengerInfoRealData,
): boolean {
    const {
        title: dataTitle,
        birthdate: dataBirthdate,
        gender: dataGender,
        itn: dataItn,
    } = preparePassengerInfoFieldsData(dataSet);

    const {
        title: realTitle,
        birthdate: realBirthdate,
        gender: realGender,
        itn: realItn,
    } = realData;

    return (
        dataTitle === realTitle &&
        dataBirthdate === realBirthdate &&
        dataGender === realGender &&
        dataItn === realItn
    );
}
