import {TFieldParams} from 'helpers/project/common/form/formFields';

export function getFieldValue(
    fields: TFieldParams[],
    fieldId: string,
    defaultValue: string | undefined = undefined,
) {
    const field = fields.find(({id}) => id === fieldId);

    return field?.compareValue || field?.value || defaultValue;
}

export function prepareDocumentFieldsData(
    fields: TFieldParams[],
    docType: string = '',
) {
    let prefix = 'passenger-';

    if (docType) {
        prefix = 'document-';
    }

    const number = getFieldValue(fields, `${prefix}number`);

    const type = docType ? docType : getFieldValue(fields, `${prefix}type`);

    const citizenship = getFieldValue(fields, `${prefix}citizenship`, 'Россия');
    const expirationDate = getFieldValue(fields, `${prefix}expirationDate`);

    const firstName = getFieldValue(fields, `${prefix}firstName`);
    const lastName = getFieldValue(fields, `${prefix}lastName`);
    const middleName = getFieldValue(fields, `${prefix}middleName`, '');
    const firstNameEn = getFieldValue(fields, `${prefix}firstNameEn`);
    const lastNameEn = getFieldValue(fields, `${prefix}lastNameEn`);
    const middleNameEN = getFieldValue(fields, `${prefix}middleNameEn`, '');

    let fio =
        lastName && firstName
            ? `${lastName} ${firstName} ${middleName}`
            : undefined;

    if (fio) {
        fio = fio.trim();
    }

    let fioEn =
        lastNameEn && firstNameEn
            ? `${lastNameEn} ${firstNameEn} ${middleNameEN}`
            : undefined;

    if (fioEn) {
        fioEn = fioEn.trim();
    }

    return {
        number,
        type,
        nameBig: fio || fioEn || undefined,
        nameSmall: fio && fioEn ? fioEn : undefined,
        citizenship,
        expirationDate,
    };
}

export function preparePassengerInfoFieldsData(fields: TFieldParams[]) {
    let title = getFieldValue(fields, 'passenger-edit-title');

    if (!title) {
        const firstName = getFieldValue(fields, 'passenger-firstName', '');
        const lastName = getFieldValue(fields, 'passenger-lastName', '');

        title = `${lastName} ${firstName}`;
    }

    const birthdate =
        getFieldValue(fields, 'passenger-birthDate') ||
        getFieldValue(fields, 'passenger-edit-birthDate');
    const gender =
        getFieldValue(fields, 'passenger-gender') ||
        getFieldValue(fields, 'passenger-edit-gender');
    const itn =
        getFieldValue(fields, 'passenger-itn') ||
        getFieldValue(fields, 'passenger-edit-itn');

    return {
        title,
        birthdate,
        gender,
        itn,
    };
}
