import {Component} from 'components/Component';
import {SearchFormFieldModal} from 'components/SearchFormFieldModal';
import {TravellersCount} from 'components/TravellersCount';
import {Button} from 'components/Button';

export class AviaTravellers extends Component {
    readonly trigger: Button;

    readonly adultsCount: TravellersCount;
    readonly childrenCount: TravellersCount;
    readonly infantCount: TravellersCount;

    readonly modal: SearchFormFieldModal;

    constructor(browser: WebdriverIO.Browser, qa: string = 'travellers') {
        super(browser, qa);

        this.trigger = new Button(browser, `${qa}-trigger`);

        this.adultsCount = new TravellersCount(browser, {
            parent: 'travellersCount',
            key: 'adults',
        });
        this.childrenCount = new TravellersCount(browser, {
            parent: 'travellersCount',
            key: 'children',
        });
        this.infantCount = new TravellersCount(browser, {
            parent: 'travellersCount',
            key: 'infants',
        });

        this.modal = new SearchFormFieldModal(this.browser);
    }

    async click(): Promise<void> {
        return this.trigger.click();
    }
}
